<?php

namespace App\Filament\Clusters\Settings\Pages;

use App\Enums\Sidebar;
use App\Filament\Clusters\Settings;
use App\Models\Setting;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Pages\SubNavigationPosition;
use Filament\Support\Exceptions\Halt;
use Illuminate\Support\Facades\Auth;

class AdvancedSetting extends Page
{
    public ?array $data = [];
    // protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static SubNavigationPosition $subNavigationPosition = SubNavigationPosition::Top;

    protected static ?int $navigationSort = Sidebar::ADVANCED_SETTINGS->value;

    protected static string $view = 'filament.clusters.settings.pages.advanced-setting';

    protected static ?string $cluster = Settings::class;

    public ?array  $record = [];

    public static function getNavigationLabel(): string
    {
        return __('messages.setting.advanced_setting');
    }

    public function getTitle(): string
    {
        return __('messages.setting.advanced_setting');
    }

    public static function canView(): bool
    {
        return Auth::user()->hasPermissionTo('manage_settings');
    }

    public function mount(): void
    {
        if (! $this->canView()) {
            abort(403); // Unauthorized access
        }

        $this->record = Setting::pluck('value', 'key')->toArray();

        // $this->form->fill([
        //     'registration_system' => $this->record['registration_system'],
        //     'emoji_system' => $this->record['emoji_system'],
        // ]);

        $this->form->fill($this->record);
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('registration_system')
                    ->label(__('messages.setting.registration_system').':')
                    ->validationAttribute(__('messages.setting.registration_system'))
                    ->inlineLabel(true)
                    ->default(false),
                Toggle::make('emoji_system')
                    ->label(__('messages.setting.emoji_system').':')
                    ->validationAttribute(__('messages.setting.emoji_system'))
                    ->inlineLabel(true)
                    ->default(false),
            ])->statePath('data');
    }

    public function save(): void
    {
        try {
            $data = $this->form->getState();
            foreach ($data as $key => $value) {
                $setting = Setting::where('key', $key)->first();
                if ($setting) {
                    $setting->update(['value' => $value]);
                } else {
                    Setting::create(['key' => $key, 'value' => $value]);
                }
            }
            Notification::make()
                ->success()
                ->title(__('messages.placeholder.settings_updated_successfully'))
                ->send();
        } catch (Halt $exception) {
            $this->notify('error', $exception->getMessage());
        }
    }
}
