<?php

namespace App\Filament\Pages;

use App\Enums\Sidebar;
use App\Http\Middleware\CheckPaddingSubscription;
use App\Models\AdSpaces as ModelsAdSpaces;
use Filament\Actions\Action;
use Filament\Forms\Components\Group;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Filament\Support\Exceptions\Halt;
use Illuminate\Support\Facades\Auth;

class AdSpaces extends Page
{
    protected static ?string $model = ModelsAdSpaces::class;

    protected $listeners = ['content-changed' => '$refresh'];

    public ?array $selectData = [];

    public ?array $desktopData = [];

    public ?array $mobileData = [];

    public ?string $id = null;

    public ?int $modalId = null;

    public ?int $modalId1 = null;

    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.pages.ad-spaces';

    protected static ?int $navigationSort = Sidebar::AD_SPACE->value;

    protected ?ModelsAdSpaces $record = null;

    public $ad_space;

    public $ad_url1;

    public $ad_code1;

    public $ad_url2;

    public $ad_code2;

    public $ad_banner1;

    public $ad_banner2;

    public static function getNavigationLabel(): string
    {
        return __('messages.ad_space.ad_space');
    }

    public function getTitle(): string
    {
        return __('messages.ad_space.ad_space');
    }

    public static function canAccess(): bool
    {
        return Auth::user()->hasPermissionTo('manage_ad');
    }

    protected static string|array $routeMiddleware = [
        CheckPaddingSubscription::class,
    ];

    protected function getForms(): array
    {
        return [
            'selectForm',
            'desktopForm',
            'mobileForm',
        ];
    }

    public function mount()
    {
        $this->selectForm->fill([
            'ad_space' => ModelsAdSpaces::HEADER,
        ]);

        $adBanners = ModelsAdSpaces::where('ad_spaces', ModelsAdSpaces::HEADER)->get();
        foreach ($adBanners as $adBanner) {
            $adBanner->ad_view == 1 ? $this->modalId1 = $adBanner->id : $this->modalId = $adBanner->id;
        }
        $this->desktopForm->model = ModelsAdSpaces::with('media')->find($this->modalId);
        $this->mobileForm->model = ModelsAdSpaces::with('media')->find($this->modalId1);
        $this->id = ModelsAdSpaces::HEADER;
        $this->updatedId(ModelsAdSpaces::HEADER);
    }

    // public function mount(): void
    // {
    //     $adBanner = ModelsAdSpaces::first();
    //     $this->modalId = $adBanner->id;

    //     if ($adBanner !== null) {
    //         $mediaItems = $adBanner->getMedia(ModelsAdSpaces::IMAGE_POST);
    //         if ($mediaItems) {
    //             $mediaUrls = $mediaItems->map(function ($media) {
    //                 return $media->getUrl();
    //             });
    //         }

    //         $this->dispatch('content-changed');
    //         $this->ad_space = $adBanner->ad_spaces;
    //         $this->ad_url1 = $adBanner->ad_url;
    //         $this->ad_code1 = $adBanner->code;
    //         $this->ad_banner1 = isset($mediaUrls[0]) ? $mediaUrls[0] : null;

    //         $this->form->fill([
    //             'ad_space' => $this->ad_space,
    //             'ad_url1' => $this->ad_url1,
    //             'ad_code1' => $this->ad_code1,
    //             'ad_banner1' => $this->ad_banner1,
    //         ]);
    //     }
    // }

    public function updatedId($value)
    {
        $adBanner = ModelsAdSpaces::where('ad_spaces', $value)->get();

        foreach ($adBanner as $singleAdBanner) {
            $singleAdBanner->ad_view == 1 ? $adBanner[1] = $singleAdBanner : $adBanner[0] = $singleAdBanner;
        }

        if ($adBanner->isNotEmpty()) {
            $mediaItems = $adBanner[0]->getMedia(ModelsAdSpaces::IMAGE_POST);
            if ($mediaItems) {
                $mediaUrls = $mediaItems->map(function ($media) {
                    return $media->getUrl();
                });
            }

            if (isset($adBanner[1])) {
                $mediaItems1 = $adBanner[1]->getMedia(ModelsAdSpaces::IMAGE_POST);
                if ($mediaItems1) {
                    $mediaUrls1 = $mediaItems1->map(function ($media) {
                        return $media->getUrl();
                    });
                }
            }

            $this->ad_space = $adBanner[0]->ad_spaces;
            $this->ad_url1 = $adBanner[0]->ad_url;
            $this->ad_code1 = $adBanner[0]->code;
            $this->ad_url2 = isset($adBanner[1]) ? $adBanner[1]->ad_url : null;
            $this->ad_code2 = isset($adBanner[1]) ? $adBanner[1]->code : null;
            $this->ad_banner1 = isset($mediaUrls[0]) ? $mediaUrls[0] : null;
            $this->ad_banner2 = isset($mediaUrls1[0]) ? $mediaUrls1[0] : null;

            if ($adBanner[0]->ad_spaces == ModelsAdSpaces::ALL_DETAILS_SIDE) {
                $this->selectForm->fill([
                    'ad_space' => $this->ad_space,
                ]);
                $this->mobileForm->fill([
                    'ad_url2' => $this->ad_url1,
                    'ad_code2' => $this->ad_code1,
                    'ad_banner2' => $this->ad_banner1,
                ]);
            } else {
                $this->selectForm->fill([
                    'ad_space' => $this->ad_space,
                ]);
                $this->desktopForm->fill([
                    'ad_url1' => $this->ad_url1,
                    'ad_code1' => $this->ad_code1,
                    'ad_banner1' => $this->ad_banner1,
                ]);
                $this->mobileForm->fill([
                    'ad_url2' => $this->ad_url2,
                    'ad_code2' => $this->ad_code2,
                    'ad_banner2' => $this->ad_banner2,
                ]);
            }
        }
    }

    public function selectForm(Form $form): Form
    {
        return $form
            ->schema([
                Select::make('ad_space')
                    ->label(__('messages.ad_space.select_ad_space').':')
                    ->validationAttribute(__('messages.ad_space.select_ad_space'))
                    ->placeholder(__('messages.ad_space.select_ad_space'))
                    ->options(ModelsAdSpaces::AD_SPACE)
                    ->live()
                    ->required()
                    ->afterStateUpdated(function ($state, $record, $operation) use ($form) {
                        $adBanners = ModelsAdSpaces::where('ad_spaces', $state)->get();
                        foreach ($adBanners as $adBanner) {
                            $adBanner->ad_view == 1 ? $this->modalId1 = $adBanner->id : $this->modalId = $adBanner->id;
                        }
                        $form->model = ModelsAdSpaces::with('media')->find($this->modalId);
                        $this->desktopForm->model = ModelsAdSpaces::with('media')->find($this->modalId);
                        $this->mobileForm->model = ModelsAdSpaces::with('media')->find($this->modalId1);
                        $this->id = $state;
                        $this->updatedId($state);
                    }),
            ])->statePath('selectData');
    }

    public function desktopForm(Form $form): Form
    {
        return $form
            ->model(ModelsAdSpaces::with('media')->find($this->modalId))
            ->schema([
                Group::make()
                    ->schema([
                        Section::make(__('messages.ad_space.desktop'))
                            ->columns(2)
                            ->schema([
                                Group::make()
                                    ->schema([
                                        TextInput::make('ad_url1')
                                            ->label(__('messages.ad_space.ad_url').':')
                                            ->validationAttribute(__('messages.ad_space.ad_url'))
                                            ->placeholder(__('messages.ad_space.ad_url'))
                                            ->required(),
                                        SpatieMediaLibraryFileUpload::make('ad_banner1')
                                            ->label(__('messages.allowed_file_size').' 800 X 130'.':')
                                            ->validationAttribute(__('messages.allowed_file_size').' 800 X 130')
                                            ->rules(['image', 'dimensions:width=800,height=130'])
                                            ->collection(ModelsAdSpaces::IMAGE_POST)
                                            ->image()
                                            ->preserveFilenames()
                                            ->imageEditor()
                                            ->hidden(function (Get $get) {
                                                return in_array($this->selectForm->getLivewire()->ad_space, [12, 13, 14, 15, 16, 17]) ? true : false;
                                            }),
                                        SpatieMediaLibraryFileUpload::make('ad_banner1')
                                            ->label(__('messages.allowed_file_size').' 1280 X 150'.':')
                                            ->validationAttribute(__('messages.allowed_file_size').' 1280 X 150')
                                            ->rules(['image', 'dimensions:width=1280,height=150'])
                                            ->collection(ModelsAdSpaces::IMAGE_POST)
                                            ->image()
                                            ->preserveFilenames()
                                            ->imageEditor()
                                            ->hidden(function (Get $get) {
                                                return in_array($this->selectForm->getLivewire()->ad_space, [12, 13, 14, 15, 16, 17]) ? false : true;
                                            }),
                                    ])->columns(1),
                                Textarea::make('ad_code1')
                                    ->label(__('messages.ad_space.ad_code').':')
                                    ->validationAttribute(__('messages.ad_space.ad_code'))
                                    ->placeholder(__('messages.ad_space.ad_code'))
                                    ->required()
                                    ->rows(7)
                                    ->columns(1)->columnSpan(1),
                            ])
                            ->visible(function (Get $get) {
                                return $this->selectForm->getLivewire()->ad_space != ModelsAdSpaces::ALL_DETAILS_SIDE && $this->selectForm->getLivewire()->ad_space != ModelsAdSpaces::ALL_DETAILS_SIDE_THEME_1 ? true : false;
                            }), ]),
            ])->statePath('desktopData');
    }

    public function mobileForm(Form $form): Form
    {
        $form
            ->model(ModelsAdSpaces::with('media')->find($this->modalId1))
            ->schema([
                Section::make(__('messages.ad_space.mobile'))
                    ->columns(2)
                    ->schema([
                        Group::make()
                            ->schema([
                                TextInput::make('ad_url2')
                                    ->label(__('messages.ad_space.ad_url').':')
                                    ->validationAttribute(__('messages.ad_space.ad_url'))
                                    ->placeholder(__('messages.ad_space.ad_url'))
                                    ->required(),
                                SpatieMediaLibraryFileUpload::make('ad_banner2')
                                    ->label(__('messages.allowed_file_size').' 350 X 290'.':')
                                    ->validationAttribute(__('messages.allowed_file_size').' 350 X 290')
                                    ->rules(['image', 'dimensions:width=350,height=290'])
                                    ->collection(ModelsAdSpaces::IMAGE_POST)
                                    ->image()
                                    ->preserveFilenames()
                                    ->imageEditor()
                                    ->hidden(function (Get $get) {
                                        return in_array($this->selectForm->getLivewire()->ad_space, [12, 13, 14, 15, 16, 17]) ? true : false;
                                    }),
                                SpatieMediaLibraryFileUpload::make('ad_banner2')
                                    ->label(__('messages.allowed_file_size').' 407 X 340'.':')
                                    ->validationAttribute(__('messages.allowed_file_size').' 407 X 340')
                                    ->rules(['image', 'dimensions:width=407,height=340'])
                                    ->collection(ModelsAdSpaces::IMAGE_POST)
                                    ->image()
                                    ->preserveFilenames()
                                    ->imageEditor()
                                    ->hidden(function (Get $get) {
                                        return in_array($this->selectForm->getLivewire()->ad_space, [12, 13, 14, 15, 16, 17]) ? false : true;
                                    }),
                            ])->columns(1),
                        Textarea::make('ad_code2')
                            ->label(__('messages.ad_space.ad_code').':')
                            ->validationAttribute(__('messages.ad_space.ad_code'))
                            ->placeholder(__('messages.ad_space.ad_code'))
                            ->required()
                            ->rows(7)
                            ->columns(1)->columnSpan(1),
                    ])
                    ->visible(function (Get $get) {
                        return $this->selectForm->getLivewire()->ad_space != ModelsAdSpaces::HEADER && $this->selectForm->getLivewire()->ad_space != ModelsAdSpaces::ALL_DETAILS_SIDE && $this->selectForm->getLivewire()->ad_space != ModelsAdSpaces::ALL_DETAILS_SIDE_THEME_1 ? true : false;
                    }),
                Section::make(__('messages.ad_space.mobile'))
                    ->columns(2)
                    ->schema([
                        Group::make()
                            ->schema([
                                TextInput::make('ad_url2')
                                    ->label(__('messages.ad_space.ad_url').':')
                                    ->validationAttribute(__('messages.ad_space.ad_url'))
                                    ->placeholder(__('messages.ad_space.ad_url'))
                                    ->required(),
                                SpatieMediaLibraryFileUpload::make('ad_banner2')
                                    ->image()
                                    ->label(__('messages.allowed_file_size').' '.'350 X 290'.':')
                                    ->validationAttribute(__('messages.allowed_file_size').' '.'350 X 290')
                                    ->rules(['image', 'dimensions:width=350,height=290'])
                                    ->imageEditor()
                                    ->preserveFilenames()
                                    ->collection(ModelsAdSpaces::IMAGE_POST),
                            ])->columns(1),
                        Textarea::make('ad_code2')
                            ->label(__('messages.ad_space.ad_code').':')
                            ->validationAttribute(__('messages.ad_space.ad_code'))
                            ->placeholder(__('messages.ad_space.ad_code'))
                            ->required()
                            ->rows(7)
                            ->columns(1)->columnSpan(1),
                    ])
                    ->visible(function () {
                        return $this->selectForm->getLivewire()->ad_space == ModelsAdSpaces::ALL_DETAILS_SIDE ? true : false;
                    }),
                Section::make(__('messages.ad_space.mobile'))
                    ->columns(2)
                    ->schema([
                        Group::make()
                            ->schema([
                                TextInput::make('ad_url2')
                                    ->label(__('messages.ad_space.ad_url').':')
                                    ->validationAttribute(__('messages.ad_space.ad_url'))
                                    ->placeholder(__('messages.ad_space.ad_url'))
                                    ->required(),
                                SpatieMediaLibraryFileUpload::make('ad_banner2')
                                    ->image()
                                    ->label(__('messages.allowed_file_size').' '.'407 X 340'.':')
                                    ->validationAttribute(__('messages.allowed_file_size').' '.'407 X 340')
                                    ->rules(['image', 'dimensions:width=407,height=340'])
                                    ->imageEditor()
                                    ->collection(ModelsAdSpaces::IMAGE_POST),
                            ])->columns(1),
                        Textarea::make('ad_code2')
                            ->label(__('messages.ad_space.ad_code').':')
                            ->validationAttribute(__('messages.ad_space.ad_code'))
                            ->placeholder(__('messages.ad_space.ad_code'))
                            ->required()
                            ->rows(7)
                            ->columns(1)->columnSpan(1),
                    ])
                    ->visible(function () {
                        return $this->selectForm->getLivewire()->ad_space == ModelsAdSpaces::ALL_DETAILS_SIDE_THEME_1 ? true : false;
                    }),

            ])->statePath('mobileData');

        return $form;
    }

    public function save(): void
    {
        $data = array_merge($this->selectForm->getState(), $this->mobileForm->getState(), $this->desktopForm->getState());

        try {
            $model = ModelsAdSpaces::where('ad_spaces', $data['ad_space'])->get();

            if ($data['ad_space'] == ModelsAdSpaces::ALL_DETAILS_SIDE || $data['ad_space'] == ModelsAdSpaces::ALL_DETAILS_SIDE_THEME_1) {
                $model[0]->update([
                    'ad_url' => $data['ad_url2'],
                    'code' => $data['ad_code2'],
                ]);
            } else {
                $model[0]->update([
                    'ad_url' => $data['ad_url1'],
                    'code' => $data['ad_code1'],
                ]);
                if (isset($model[1])) {
                    $model[1]->update([
                        'ad_url' => $data['ad_url2'],
                        'code' => $data['ad_code2'],
                    ]);
                }
            }

            Notification::make()
                ->success()
                ->title(__('messages.placeholder.adSpaces_updated_successfully'))
                ->send();
        } catch (Halt $exception) {
            $this->notify('error', $exception->getMessage());
        }
    }

    public function getFormAction(): array
    {
        return [
            Action::make('save')
                ->label(__('filament-panels::resources/pages/edit-record.form.actions.save.label'))
                ->submit('save'),
        ];
    }
}
