<?php

namespace App\Filament\Resources;

use App\Enums\Sidebar;
use App\Filament\Resources\PostCommentsResource\Pages;
use App\Filament\Resources\PostCommentsResource\RelationManagers;
use App\Http\Middleware\CheckPaddingSubscription;
use App\Models\Comment;
use App\Models\Post;
use App\Models\PostComments;
use Filament\Forms;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\ToggleButtons;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\ToggleColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class PostCommentsResource extends Resource
{
    protected static ?string $model = Comment::class;

    protected static ?string $navigationIcon = 'heroicon-o-chat-bubble-oval-left-ellipsis';

    protected static ?int $navigationSort = Sidebar::COMMENTS->value;

    protected static string|array $routeMiddleware = [
        CheckPaddingSubscription::class,
    ];

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        $table = $table->modifyQueryUsing(function (Builder $query) {
            $query = $query->join('posts', 'comments.post_id', '=', 'posts.id')
                ->select('comments.*', 'posts.title as post_title');
        });

        return $table
            ->paginated([10, 25, 50])
            ->defaultSort('id', 'desc')
            ->columns([
                TextColumn::make('post_title')
                    ->label(__('messages.post.posts'))
                    ->width(400)

                    ->sortable()
                    ->searchable()
                    ->wrap(),
                TextColumn::make('email')
                    ->label(__('messages.emails.email'))
                    ->sortable()
                    ->searchable(),
                TextColumn::make('comment')
                    ->label(__('messages.comment.comment'))
                    ->sortable()
                    ->searchable()
                    ->width(800)
                    ->wrap(),
                ToggleColumn::make('status')
                    ->label(__('messages.status'))
                    ->afterStateUpdated(function ($state) {
                        Notification::make()
                            ->success()
                            ->title(__('messages.placeholder.status_updated_successfully'))
                            ->send();
                    }),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\DeleteAction::make()
                    ->iconButton()
                    ->modalHeading(__('messages.delete') . ' ' . __('messages.comment.comment'))
                    ->successNotificationTitle(__('messages.placeholder.comment_deleted_successfully')),
            ])
            ->actionsColumnLabel(__('messages.common.action'))
            ->actionsAlignment(function () {
                return Session::get('locale') == 'ar' ? 'left' : 'right';
            })
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make()
                        ->tooltip(__('messages.delete'))
                        ->modalHeading(__('messages.delete') . ' ' . __('messages.selected') . ' ' . __('messages.comment.comments'))
                        ->successNotificationTitle(__('messages.placeholder.comment_deleted_successfully')),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ManagePostComments::route('/'),
        ];
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.comments');
    }

    public static function getmodelLabel(): string
    {
        return __('messages.comments');
    }

    public static function canViewAny(): bool
    {
        return Auth::user()->hasPermissionTo('manage_comment');
    }
}
