<?php

namespace App\Filament\Resources\StaffResource\Pages;

use App\Filament\Resources\StaffResource;
use Filament\Actions;
use Filament\Actions\Action;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;
use Illuminate\Database\Eloquent\Model;
use Mockery\Matcher\Not;

class EditStaff extends EditRecord
{
    protected static string $resource = StaffResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // Actions\ViewAction::make(),
            // Actions\DeleteAction::make(),
            Action::make('back')
                ->label(__('messages.common.back'))
                ->url($this->getResource()::getUrl('index')),
        ];
    }
    protected function handleRecordUpdate(Model $record, array $data): Model
    {
        if ($data['gender'] == 0 || empty($data['gender'])) {
            Notification::make()
                ->danger()
                ->title(__('messages.common.required', ['attribute' => __('messages.staff.gender')]))
                ->send();
            $this->halt();
        }
        return parent::handleRecordUpdate($record, $data);
    }
    
    protected function getSavedNotificationTitle(): ?string
    {
        return __('messages.placeholder.staff_updated_successfully');
    }

    // protected function getSavedNotification(): ?Notification
    // {
    //     return Notification::make()
    //     ->success()
    //     ->title($this->getSavedNotificationTitle())
    //     ->body("Staff has been updated successfully.");
    // }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    public function getTitle(): string
    {
        return __('messages.common.edit').' '.__('messages.staff.staff');
    }
}
