@php
    $settings = App\Models\Setting::pluck('value', 'key')->toArray();
@endphp
<div>
    <x-filament-panels::form wire:submit="register" id="registrationForm">
        <div class="w-full pb-2 text-center relative flex flex-col items-center">
            <a href="{{ route('front.home') }}" data-turbo="false"
                class="text-decoration-none sidebar-logo flex items-center" target="_blank" title="InfyNews">
                <div class="image image-mini">
                    <img src="{{ getAppLogo() }}" class="me-4" alt="InfyNews-logo" width="40px" height="30px">
                </div>
            </a>
            <h1
                class="fi-simple-header-heading text-center text-2xl font-bold tracking-tight text-gray-950 dark:text-white">
                {{ __('messages.common.create_an_account') }}
            </h1>

            <p class="fi-simple-header-subheading mt-2 text-center text-sm text-gray-500 dark:text-gray-400">
                {{ __('messages.common.already_have_an_account') }}
                <a href="{{ route('filament.auth.auth.login') }}"
                    class="fi-link group/link relative inline-flex items-center justify-center outline-none fi-size-md fi-link-size-md gap-1.5 fi-color-custom fi-color-primary fi-ac-action fi-ac-link-action">
                    <span
                        class="font-semibold text-sm text-custom-600 dark:text-custom-400 group-hover/link:underline group-focus-visible/link:underline custom-signup-link"
                        style="--c-400:var(--primary-400);--c-600:var(--primary-600);">
                        {{ __('messages.common.sign_in_here') }}
                    </span>
                </a>
            </p>
        </div>
        {{ $this->form }}
        @if ($settings['show_captcha_on_registration'] == '1')
            <div class="form-group">
                <div class="g-recaptcha" id="gRecaptchaContainerRegistration" style="padding-bottom: 10px;"
                    data-sitekey="{{ $settings['site_key'] }}"></div>
                <span id="g-recaptcha-error" class="gap-2" style="color: red;"></span>
            </div>
            <input type="hidden" value="{{ $settings['show_captcha'] }}">
        @endif
        <x-filament-panels::form.actions :actions="$this->getFormActions()" />
    </x-filament-panels::form>
</div>

<script src="https://www.google.com/recaptcha/api.js"></script>
<script>
    document.getElementById("registrationForm").addEventListener("submit", function(event) {
        event.preventDefault();

        let captcha = grecaptcha.getResponse();

        // Clear any previous error
        document.getElementById("g-recaptcha-error").innerHTML = "";

        if (captcha === "") {
            // Show error if reCAPTCHA isn't completed
            document.getElementById("g-recaptcha-error").innerHTML = "Google reCAPTCHA is required";
            return;
        } else {
            // If captcha is valid, submit the form
            @this.call('register');
        }
    });

    document.addEventListener('validationFailed', function() {
        setTimeout(() => {
            window.location.reload();
        }, 1000);
    })
</script>
