<div class="pt-10">
    {{-- @if ($posts->count() > 0 && $user_data->count() > 0) --}}
    @if (!is_null($posts) && !is_null($user_data) && $posts->count() > 0 && $user_data->count() > 0)
        <div class="container mx-auto max-w-7xl xl:px-0 lg:px-10 md:px-8 px-4">
            <div class="lg:pt-20 md:pt-14 xs:pt-12 pt-10">
                <div class="container lg:grid lg:grid-cols-3 gap-8">
                    <div class="col-span-2 sm:mb-0 mb-10">
                        @foreach ($posts->take(5) as $post)
                            <div class="sm:flex mb-8">
                                <div class="sm:w-[328px] h-[205px] sm:min-w-[328px] w-full rounded-lg overflow-hidden md:mr-5 sm:mr-4 sm:mb-0 mb-4 relative">
                                    <a href="{{ route('detailPage', $post->slug) }}">
                                        <img src="{{ $post->post_image }}" class="w-full h-full object-cover" />
                                    </a>
                                    <a href="{{ route('categoryPage', $post->category->slug) }}"
                                        class="bg-primary rounded-tr-md rounded-br-md text-white font-bold text-xs py-1.5 pl-4 pr-2.5 absolute left-0 top-5">{{ $post->category->name }}</a>
                                </div>
                                <div class="">
                                    <h5 class="md:text-[22px] text-lg font-semibold mb-2">
                                        {{ $post->title }}
                                    </h5>
                                    <p class="pt-3 text-gray-300 sm:text-base text-sm font-medium line-clamp-3">
                                        {!! \Illuminate\Support\Str::limit($post->description, 130, '...') !!}
                                    </p>
                                    <div class="sm:pt-5 flex">
                                        <div class="flex sm:pt-0 pt-3">
                                            <div class="inline-flex items-center mr-5">
                                                <div class="w-8 h-8 rounded-full overflow-hidden mr-2">
                                                    <img src="{{ $user_data->profile_image }}" loading="lazy"
                                                        class="w-full h-full object-cover" />
                                                </div>
                                                <div class="text-gray-300">{{ Str::limit($user_data->full_name, 15) }}</div>
                                            </div>
                                            <div class="flex items-center mr-5">
                                                <div class="w-4 h-4 mr-2.5">
                                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M16 7.50649C15.9036 5.94807 15.3528 4.45189 14.4155 3.20241C13.4783 1.95294 12.1955 1.00479 10.7254 0.474856C9.25527 -0.0550793 7.66206 -0.143633 6.14217 0.220111C4.62228 0.583855 3.24216 1.384 2.17195 2.52189C1.10174 3.65979 0.388228 5.08569 0.119375 6.62382C-0.149478 8.16194 0.0380816 9.74505 0.658932 11.178C1.27978 12.6109 2.30678 13.831 3.61332 14.6878C4.91986 15.5447 6.44882 16.0008 8.01171 16H12.6668C13.5506 15.9991 14.3979 15.648 15.0228 15.0237C15.6477 14.3994 15.9991 13.5529 16 12.67V7.50649ZM14.6667 12.67C14.6667 13.1999 14.456 13.7081 14.081 14.0828C13.7059 14.4575 13.1972 14.668 12.6668 14.668H8.01171C7.07104 14.6676 6.14103 14.4691 5.2823 14.0855C4.42358 13.7018 3.65543 13.1417 3.02794 12.4416C2.39742 11.7418 1.92395 10.9154 1.63927 10.0178C1.35459 9.12028 1.26529 8.17229 1.37735 7.23743C1.5543 5.76287 2.21744 4.38907 3.26223 3.33262C4.30701 2.27616 5.67402 1.59714 7.14775 1.4026C7.43523 1.3666 7.72465 1.34836 8.01438 1.34799C9.56795 1.34375 11.0734 1.88605 12.2668 2.87979C12.9638 3.4585 13.5359 4.1726 13.9484 4.97877C14.361 5.78495 14.6053 6.66643 14.6667 7.56976V12.67Z"
                                                            fill="#C00F24" />
                                                        <path
                                                            d="M5.33384 6.00999H8.00038C8.17718 6.00999 8.34674 5.93982 8.47176 5.81492C8.59678 5.69002 8.66701 5.52062 8.66701 5.34399C8.66701 5.16735 8.59678 4.99795 8.47176 4.87306C8.34674 4.74816 8.17718 4.67799 8.00038 4.67799H5.33384C5.15703 4.67799 4.98747 4.74816 4.86245 4.87306C4.73743 4.99795 4.6672 5.16735 4.6672 5.34399C4.6672 5.52062 4.73743 5.69002 4.86245 5.81492C4.98747 5.93982 5.15703 6.00999 5.33384 6.00999Z"
                                                            fill="#C00F24" />
                                                        <path
                                                            d="M10.6669 7.34199H5.33384C5.15703 7.34199 4.98747 7.41216 4.86245 7.53706C4.73743 7.66196 4.6672 7.83136 4.6672 8.00799C4.6672 8.18463 4.73743 8.35402 4.86245 8.47892C4.98747 8.60382 5.15703 8.67399 5.33384 8.67399H10.6669C10.8437 8.67399 11.0133 8.60382 11.1383 8.47892C11.2633 8.35402 11.3336 8.18463 11.3336 8.00799C11.3336 7.83136 11.2633 7.66196 11.1383 7.53706C11.0133 7.41216 10.8437 7.34199 10.6669 7.34199Z"
                                                            fill="#C00F24" />
                                                        <path
                                                            d="M10.6669 10.006H5.33384C5.15703 10.006 4.98747 10.0762 4.86245 10.2011C4.73743 10.326 4.6672 10.4954 4.6672 10.672C4.6672 10.8486 4.73743 11.018 4.86245 11.1429C4.98747 11.2678 5.15703 11.338 5.33384 11.338H10.6669C10.8437 11.338 11.0133 11.2678 11.1383 11.1429C11.2633 11.018 11.3336 10.8486 11.3336 10.672C11.3336 10.4954 11.2633 10.326 11.1383 10.2011C11.0133 10.0762 10.8437 10.006 10.6669 10.006Z"
                                                            fill="#C00F24" />
                                                    </svg>
                                                </div>
                                                <span class="text-gray-200 sm:text-base text-sm font-medium">{{ $post->comment->count() ? $post->comment->count() : 0 }}</span>
                                            </div>
                                            <div class="flex items-center">
                                                <div class="w-4 h-4 mr-2.5">
                                                    <svg width="16" height="12" viewBox="0 0 16 12" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M15.5112 4.34286C14.4776 2.72103 12.1265 0 8 0C3.87353 0 1.5224 2.72103 0.488783 4.34286C0.169253 4.84078 0 5.4146 0 6C0 6.5854 0.169253 7.15923 0.488783 7.65714C1.5224 9.27897 3.87353 12 8 12C12.1265 12 14.4776 9.27897 15.5112 7.65714C15.8307 7.15923 16 6.5854 16 6C16 5.4146 15.8307 4.84078 15.5112 4.34286ZM14.375 6.98491C13.4873 8.3756 11.478 10.7159 8 10.7159C4.52196 10.7159 2.5127 8.3756 1.62503 6.98491C1.43519 6.68895 1.33464 6.34791 1.33464 6C1.33464 5.65209 1.43519 5.31105 1.62503 5.01509C2.5127 3.6244 4.52196 1.28411 8 1.28411C11.478 1.28411 13.4873 3.62183 14.375 5.01509C14.5648 5.31105 14.6654 5.65209 14.6654 6C14.6654 6.34791 14.5648 6.68895 14.375 6.98491Z"
                                                            fill="#C00F24" />
                                                        <path
                                                            d="M8 2.78973C7.34097 2.78973 6.69675 2.97801 6.14879 3.33076C5.60082 3.68351 5.17374 4.18488 4.92154 4.77148C4.66934 5.35808 4.60336 6.00356 4.73193 6.62629C4.8605 7.24903 5.17785 7.82104 5.64385 8.27001C6.10985 8.71897 6.70358 9.02472 7.34994 9.14859C7.9963 9.27246 8.66628 9.20889 9.27514 8.96591C9.884 8.72293 10.4044 8.31146 10.7705 7.78353C11.1367 7.25561 11.3321 6.63493 11.3321 6C11.331 5.1489 10.9796 4.33294 10.355 3.73112C9.73032 3.1293 8.8834 2.79075 8 2.78973ZM8 7.92617C7.60458 7.92617 7.21805 7.8132 6.88927 7.60155C6.56049 7.3899 6.30424 7.08907 6.15293 6.73711C6.00161 6.38515 5.96201 5.99786 6.03916 5.62422C6.1163 5.25059 6.30671 4.90738 6.58631 4.638C6.86591 4.36862 7.22215 4.18517 7.60996 4.11085C7.99778 4.03653 8.39977 4.07467 8.76508 4.22046C9.1304 4.36624 9.44264 4.61313 9.66232 4.92988C9.882 5.24664 9.99926 5.61904 9.99926 6C9.99926 6.51085 9.78862 7.00078 9.41369 7.362C9.03876 7.72323 8.53024 7.92617 8 7.92617Z"
                                                            fill="#C00F24" />
                                                    </svg>
                                                </div>
                                                <span class="text-gray-200 sm:text-base text-sm font-medium">{{ getPostViewCount($post->id) . ' ' . __('messages.details.views') }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="">
                        <!-- author-details -->
                        <div class="light-gray-bg rounded-xl xs:p-5 p-4 mb-8">
                            <div class="flex mb-4">
                                <div class="me-4 w-6">
                                    <svg width="24" height="25" viewBox="0 0 24 25" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_2094_1188)">
                                            <path
                                                d="M12 12.5C13.1867 12.5 14.3467 12.1481 15.3334 11.4888C16.3201 10.8295 17.0892 9.89246 17.5433 8.7961C17.9974 7.69975 18.1162 6.49335 17.8847 5.32946C17.6532 4.16557 17.0818 3.09648 16.2426 2.25736C15.4035 1.41825 14.3344 0.846802 13.1705 0.615291C12.0067 0.38378 10.8003 0.5026 9.7039 0.956725C8.60754 1.41085 7.67047 2.17989 7.01118 3.16658C6.35189 4.15328 6 5.31331 6 6.5C6.00159 8.09081 6.63424 9.61602 7.75911 10.7409C8.88399 11.8658 10.4092 12.4984 12 12.5ZM12 2.5C12.7911 2.5 13.5645 2.7346 14.2223 3.17412C14.8801 3.61365 15.3928 4.23836 15.6955 4.96927C15.9983 5.70017 16.0775 6.50444 15.9231 7.28036C15.7688 8.05629 15.3878 8.76902 14.8284 9.32843C14.269 9.88784 13.5563 10.2688 12.7804 10.4231C12.0044 10.5775 11.2002 10.4983 10.4693 10.1955C9.73836 9.89277 9.11365 9.38008 8.67412 8.72228C8.2346 8.06449 8 7.29113 8 6.5C8 5.43914 8.42143 4.42172 9.17157 3.67158C9.92172 2.92143 10.9391 2.5 12 2.5Z"
                                                fill="#C00F24" />
                                            <path
                                                d="M12 14.5C9.61386 14.5026 7.32622 15.4517 5.63896 17.139C3.95171 18.8262 3.00265 21.1139 3 23.5C3 23.7652 3.10536 24.0196 3.29289 24.2071C3.48043 24.3946 3.73478 24.5 4 24.5C4.26522 24.5 4.51957 24.3946 4.70711 24.2071C4.89464 24.0196 5 23.7652 5 23.5C5 21.6435 5.7375 19.863 7.05025 18.5503C8.36301 17.2375 10.1435 16.5 12 16.5C13.8565 16.5 15.637 17.2375 16.9497 18.5503C18.2625 19.863 19 21.6435 19 23.5C19 23.7652 19.1054 24.0196 19.2929 24.2071C19.4804 24.3946 19.7348 24.5 20 24.5C20.2652 24.5 20.5196 24.3946 20.7071 24.2071C20.8946 24.0196 21 23.7652 21 23.5C20.9974 21.1139 20.0483 18.8262 18.361 17.139C16.6738 15.4517 14.3861 14.5026 12 14.5Z"
                                                fill="#C00F24" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_2094_1188">
                                                <rect width="24" height="24" fill="white"
                                                    transform="translate(0 0.5)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                                <p class="text-base font-medium text-gray-300">Member
                                    Since
                                    {{ ucfirst(__('messages.common.' . strtolower($user_data->created_at->format('M')))) }}
                                    {{ $user_data->created_at->format('d, Y') }}</p>
                            </div>
                            <div class="flex">
                                <div class="me-4 w-6">
                                    <svg width="24" height="20" viewBox="0 0 24 20" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M19 0H5C3.67441 0.00144351 2.40356 0.480802 1.46622 1.33293C0.528882 2.18505 0.00158786 3.34037 0 4.54545V15.4545C0.00158786 16.6596 0.528882 17.8149 1.46622 18.6671C2.40356 19.5192 3.67441 19.9986 5 20H19C20.3256 19.9986 21.5964 19.5192 22.5338 18.6671C23.4711 17.8149 23.9984 16.6596 24 15.4545V4.54545C23.9984 3.34037 23.4711 2.18505 22.5338 1.33293C21.5964 0.480802 20.3256 0.00144351 19 0ZM5 1.81818H19C19.5988 1.81925 20.1835 1.9832 20.679 2.28891C21.1744 2.59463 21.5579 3.02813 21.78 3.53364L14.122 10.4964C13.5584 11.0066 12.7954 11.2932 12 11.2932C11.2046 11.2932 10.4416 11.0066 9.878 10.4964L2.22 3.53364C2.44215 3.02813 2.82561 2.59463 3.32105 2.28891C3.81648 1.9832 4.40122 1.81925 5 1.81818ZM19 18.1818H5C4.20435 18.1818 3.44129 17.8945 2.87868 17.383C2.31607 16.8716 2 16.1779 2 15.4545V5.90909L8.464 11.7818C9.40263 12.633 10.6743 13.1109 12 13.1109C13.3257 13.1109 14.5974 12.633 15.536 11.7818L22 5.90909V15.4545C22 16.1779 21.6839 16.8716 21.1213 17.383C20.5587 17.8945 19.7957 18.1818 19 18.1818Z"
                                            fill="#C00F24" />
                                    </svg>
                                </div>
                                <a href="mailto:{{ $user_data->email }}" class="text-base font-medium text-gray-300 break-words">{{ $user_data->email }}</a>
                            </div>
                        </div>
                        <!-- following -->
                        @if ($following->count() || $followers->count())
                            <div class="light-gray-bg rounded-xl xs:p-5 p-4 mb-8">
                                @if ($following->count())
                                    <h4 class="text-xl font-semibold mb-4">
                                            {{ __('messages.following') }} ({{ $following->count() }})
                                    </h4>
                                    <div class="flex gap-3 flex-wrap mb-5">
                                        @foreach ($following as $follow)
                                            <div class="w-11 h-11 rounded-full overflow-hidden">
                                                <img src="{{ $follow->follower->profile_image }}" loading="lazy"
                                                    class="w-full h-full object-cover" />
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                                @if ($followers->count())
                                    <h4 class="text-xl font-semibold mb-4">
                                            {{ __('messages.followers') }} ({{ $followers->count() }})
                                    </h4>
                                    <div class="flex gap-3 flex-wrap ">
                                        @foreach ($followers as $follow)
                                            <div class="w-11 h-11 rounded-full overflow-hidden">
                                                <img src="{{ $follow->follow->profile_image }}" loading="lazy"
                                                    class="w-full h-full object-cover" />
                                            </div>
                                        @endforeach
                                    </div>
                                @endif
                            </div>
                        @endif
                        <div>
                            @if (!empty(array_filter(getPopularNews())))
                                @include('theme1.most_read', ['popularNews' => array_slice(getPopularNews(), 0, 4)])
                            @endif
                        </div>
                    </div>
                </div>
                <div class="overflow-auto">
                    {{-- @if ($posts->count() > 0)
                        {{ $posts->links('pagination::tailwind-theme-1') }}
                    @endif --}}
                </div>
            </div>
        </div>
    @else
        <div class="flex text-base md:text-[22px] text-lg font-semibold justify-evenly mt-10">
            <h1>{{ __('messages.no_matching_records_found') }}</h1>
        </div>
    @endif
</div>
