<?php

// use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\FollowersController;
use App\Http\Controllers\LandingPageController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\PaypalController;
use App\Http\Controllers\PollController;
use App\Http\Controllers\SocialAuthController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\SubscriptionController;
use Filament\Http\Controllers\Auth\EmailVerificationController;
use Filament\Http\Controllers\Auth\LogoutController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

// Route::get('/', function () {
//     return view('welcome');
// });
// Route::get('/login', function () {
//     return redirect('admin/login');
// })->name('login');
// Route::get('/logout', [LogoutController::class, '__invoke'])->name('logout');

// Route::get('email/verify/{id}/{hash}', [EmailVerificationController::class, 'verify'])->name('filament.admin.auth.email-verification.verify');
// Route::get('email/verify/{id}/{hash}', [EmailVerificationController::class, 'verify'])->name('verification.verify');


// subscription controler

Route::post('stripe/subscription-purchase', [StripeController::class, 'purchase'])->name('stripe.purchase');
Route::post(
    'purchase-subscription',
    [SubscriptionController::class, 'purchaseSubscription']
)->name('purchase-subscription');
Route::get('stripe-success', [SubscriptionController::class, 'success'])->name('stripe.success');
Route::get('stripe-failed', [SubscriptionController::class, 'failed'])->name('stripe.failed');

//paypal
Route::post('paypal-onboard', [PaypalController::class, 'onBoard'])->name('paypal.init');
Route::get('paypal-payment-success', [PaypalController::class, 'success'])->name('paypal.success');
Route::get('paypal-payment-failed', [PaypalController::class, 'failed'])->name('paypal.failed');

//manual
Route::post(
    'subscription-purchase/{plan}/manual',
    [SubscriptionController::class, 'manualPay']
)->name('subscription.manual');

Route::get('/download-attachment/{id}', [SubscriptionController::class, 'downloadAttachment'])->name('download.attachment');


//front landing ui

Route::middleware('xss', 'setLanguage')->group(function () {
    Route::get('/', [LandingPageController::class, 'index'])->name('front.home');
    Route::post('/comments', [LandingPageController::class, 'saveCommentsUser'])->name('comment.store');
    Route::delete('/comments/{comment}', [LandingPageController::class, 'destroyComment'])->name('comment.destroy');
    Route::post('subscribe', [LandingPageController::class, 'saveSubscribeUser'])->name('subscribe.store');
    Route::post('language-change-home', [LandingPageController::class, 'detailPage'])->name('language.change.home');

    Route::get('p', [LandingPageController::class, 'allPosts'])->name('allPosts');
    Route::get('p/{data}', [LandingPageController::class, 'detailPage'])->name('detailPage')->middleware('analytic');
    Route::get('p/{data}/{id}', [LandingPageController::class, 'detailPage'])->name('detailPage.gallery');
    Route::get('c/{category?}/{slug?}', [LandingPageController::class, 'categoryPage'])->name('categoryPage');
    Route::get('t/{tag}', [LandingPageController::class, 'popularTagPage'])->name('popularTagPage');
    Route::get('/g/{id?}', [LandingPageController::class, 'galleryPage'])->name('galleryPage');
    Route::post('audio-detail-page', [LandingPageController::class, 'audioDetails'])->name('audioDetailPage');

    Route::get('/terms-conditions', [LandingPageController::class, 'displayTerms'])->name('page.Terms');
    Route::get('/support', [LandingPageController::class, 'displayTerms'])->name('page.support');
    Route::get('/privacy', [LandingPageController::class, 'displayTerms'])->name('page.privacy');

    Route::get('/contact-save', [ContactController::class, 'store'])->name('contact.store');
    Route::get('/contact', [ContactController::class, 'index'])->name('contact.index');

    Route::get('profile/{user}', [LandingPageController::class, 'profileDashboard'])->name('userDetails');

    Route::get('follow/{user}', [FollowersController::class, 'store'])->name('followUser');
    Route::get('nu-follow/{user}', [FollowersController::class, 'unFollow'])->name('UnFollowUser');

    //vote poll route
    Route::post('vote-poll', [PollController::class, 'votePoll'])->name('vote.poll');

    //pages
    Route::get('page/{slug}', [PageController::class, 'showPageSlug'])->name('pages.show-page-slug');

    //reaction
    Route::post('post-reaction', [LandingPageController::class, 'postReaction'])->name('post-reaction');


    Route::get('cookie', [LandingPageController::class, 'declineCookie'])->name('declineCookie');

    Route::get('change-theme', [LandingPageController::class, 'themeChange'])->name('themeChange');
});

Route::fallback(function () {
    return view('errors/404');
});



Route::get('/login/{provider}', [SocialAuthController::class, 'redirectToSocial'])->name('social.login');
Route::get('/login/{provider}/callback', [SocialAuthController::class, 'handleSocialCallback']);


include 'auth.php';
require __DIR__ . '/upgrade.php';
